% finaquant Financial Analytics - www.finaquant.com
% Tunc Ali Ktkcoglu  2012, version: 12Mar2012
% TITLE: Quick Reference Guide to matlab
% Related web page:
% http://finaquant.com/quick-start-rer-matlab-and-r/599

% How to run this script:
% Ensure that this file is in the current working directory of matlab
% Execute script with command: >matlab_quick_reference

% special keys:
% upward arrow: next command in command history
% downward arrow: previous arrow in command history

% examples for useful help commands:
% >>help % general help
% >>help elfun % elementary math functions
% >>help while % how while works
% >>help while % how while works
% >>lookfor optimization % keyword search

disp('Current directory')
pwd
disp('***********************************************************')
disp('Create vectors')
disp('***********************************************************')
% horizontal vector (i.e. 1xN matrix)
v = [1 3 6 9]

% Series: StartValue:Interval:EndValue
v_series_1_2_9 = 1:2:9
v_series_10_1_5 = 10:-1:5

% vector with multiple (repeating) constant values
v_all2_1x4 = ones(1,4) * 2

% horizontal and vertical vectors
w_horizontal_1x3 = [1 3 5]
w_vertical_3x1 = [1 3 5]'

disp('***********************************************************')
disp('Create matrices')
disp('***********************************************************')
% 2x4 matrix with uniformly distributed (between 0 and 1) random element values
A_rand_2x4 = rand(2,4)
% 1x3 matrix with all 3s
B_all3_1x3 = 3 * ones(1,3)
% 3x2 matrix with all 0s
C_all0_3x2 = zeros(3,2)

disp('***********************************************************')
disp('Assignment')
disp('***********************************************************')
% assignment with text output to console
a = 5

% assignment without text output to console (semicolon at the end)
a = 5;

disp('***********************************************************')
disp('Show all predefined variables')
disp('***********************************************************')
who

disp('***********************************************************')
disp('Size of a matrix or vector')
disp('***********************************************************')
% create a 3x4 matrix
A = floor(100 * rand(3,4))

% row and column size
[rows,columns] = size(A)
nrows = size(A,1)
ncols = size(A,2)

% largest dimension of a = max(#rows, #columns)
mlen = length(A);

% number of elements in a matrix
noofelements = numel(A);

% number of elements in a vector
v = [1 3 5 7]
vlen = length(v)

disp('***********************************************************')
disp('Access elements of a vector or matrix')
disp('***********************************************************')
A
A_e23 = A(2,3)
A_row2 = A(2,:)
A_col2 = A(:,2)

v
v_e1 = v(1)
v_e1to3 = v(1:3)
v_e124 = v([1 2 4])

disp('***********************************************************')
disp('Transpose vectors and matrices')
disp('***********************************************************')
v = [1 2 3]
v_transpose = v'

X = [1 2 3; 4 5 6]
X_transpose = X'

disp('Add column(s) or row(s) to a matrix')
X = [1 2; 3 4]

% horizontal (column-wise) concatenation
v = [5 10]'
X_v_horizontal = [X, v]

% vertical (row-wise) concatenation
w = [5 10]
X_w_vertical = [X; w]

disp('***********************************************************')
disp('Matrix partitioning (submatrices)')
disp('***********************************************************')
X = [1 2 3 4; 5 6 7 8; 9 10 11 12]

% single row of a matrix 
X_row2 = X(2,:)
% single column of a matrix 
X_col3 = X(:,3)

% submatrix with specified rows and columns
X_rows12_cols234 = X(1:2, 2:4)
X_rows13_cols24 = X([1 3], [2 4])

disp('***********************************************************')
disp('Insert a matrix into another matrix')
disp('***********************************************************')
X = [1 2 3 4; 5 6 7 8]
M = X;
Y = [10 11; 12 13]
% insert by replacing elements (element assignment)
M(:, [2 3]) = Y;
X_insert_Y = M

% insert by (horizontal) extension
X_extend_by_Y = [X(:,1), Y, X(:, 2:4)]

disp('***********************************************************')
disp('Basic matrix operations')
disp('***********************************************************')
X = [2 4 9; 16 25 36]

% square root of all elements
X_square_root = sqrt(X)

% square of all elements
X_square = X .^2

% matrix matrix multiplication
V = [1 2 3]'
X_x_V = X * V

% matrix scalar multiplication
X_x_2 = 2 * X

% matrix scalar division
X_div_10 = X / 10

% elementwise multiplication 
X_X = X .* X
V_V = V .* V

% elementwise division
X_div_X = X ./ X

% inverse matrix
A = [1 3; 2 4]
A_inverse = inv(A)
% Test inverse
AxAinv = A * A_inverse

disp('***********************************************************')
disp('Solve a typical matrix equation: A x b = c --> b = ?')
disp('***********************************************************')
A = [1 2; 3 4]
c = [1 1]'
b = inv(A) * c
% Test the result
c_test = A * b

disp('***********************************************************')
disp('Sorting vectors')
disp('***********************************************************')
v = [2 5 1 4]
% sort vector in ascending order
% w: sorted vector
% ind: element indices such that w = v(ind)
[w, ind] = sort(v,'ascend')
w_test = v(ind)

disp('***********************************************************')
disp('Sorting matrices')
disp('***********************************************************')
X = [3 5 2 7; 1 10 12 5; 3 2 8 10; 1 6 4 2]
% sort rows after first column
X_sort_col1_ascend = sortrows(X, 1)
% sort rows after first column in descending order
X_sort_col1_descend = sortrows(X, -1)
% sort rows after first and second columns
X_sort_cols12 = sortrows(X, [1 2])
% sort columns after the first row
X_sort_row1 = sortrows(X',1)'

disp('***********************************************************')
disp('Aggregation functions like sum, mean, max, min, stdev, variance')
disp('***********************************************************')
X = [1 4 2; 3 6 2]
% sum of each column (columnwise sum)
X_column_sum = sum(X) % or sum(X,1)

% Generally, func(X, dim):
% dim = 1 ' columnwise operation
% dim = 2 ' rowwise operation
% default dim (dimension) is 1 (columnwise) if no explicit dimension is given

% sum of each row
X_row_sum = sum(X, 2)

% sum of all elements of a matrix
X_all_sum = sum(sum(X))

% mean value of each column
X_column_mean = mean(X)

% standard deviation of each row
X_column_stdev = std(X,1)

% largest element
X_largest_element = max(max(X))

disp('***********************************************************')
disp('Text output to console')
disp('***********************************************************')
% display simple text only
disp('this is a sentence');
% text concatenate
str_concat = ['motor ', 'car', 's'] 
% convert numbers to string
v = [1 2 3 4];
disp(['v = ', num2str(v)]);
% text output with an integer parameter, "\n" for explicit line feed
fprintf('a_integer is equal to %d\n', 5)
% text output with a floating number
fprintf('b_float is equal to %f\n', sqrt(2))
% multiple arguments
fprintf('Results: a = %d, b = %.1f, c = %.2f\n', 4, 5.18, 6.12);

disp('***********************************************************')
disp('Programming language constructs')
disp('***********************************************************')
% while loop
v = [8 5 3 7 2 8 1 2]
% start from left, find the first number smaller than or equal to 2
i = 1; 
while v(i) > 2
    i = i+1; 
end
fprintf('Results: i = %d,v(i) = %d\n',i,v(i));
% alternative method
a = find(v <= 2);
i_test = a(1)
% look for find() in matlab help: It is a useful and versatile search function

% for loop
% generate identity matrix (all diagonal elements 1, others 0)
I = zeros(3,3);
for i=1:3
    I(i, i) = 1;
end
I
% alternative method
I = eye(3);

% if statements
x = 5;
% check if x is in range (2,10)
if (x > 2) && (x < 10) 
    disp('x is in range') 
else
    disp('x is not in range')
end
% see keywords like switch, break and continue for other programming
% constructs

disp('   ')
disp('Writing scripts and functions')
% this very file itself is an example script

% function "difference" with multiple arguments and a single return value
% text file "difference.m" should be in the same working directory
diff = difference(10,2)

% function with multiple return values; text file sumdif.m in current
% directory:
[sums,diff] = sumdif(5,3)

disp('***********************************************************')
disp('Plotting graphs')
disp('***********************************************************')
% Just move the window of the last one to see every figure; 
% multiple figures may come exactly on top of each other.

% plot x-square function
x = 1:100; 
y = x .^ 2;
plot(x, y); 
title('y = x-square')
xlabel('x')
ylabel('y')
figure  % opens a new diagram so that the previous one is not overwritten

% plot two curves on the same graph
% first curve is red, second is blue
x1 = 1:100;
y1 = x1 .^ 2; 
x2 = x1; 
y2 = (x2 - 5) .^ 2; 
plot(x1, y1,'r', x2, y2,'b')
title('two curves in a graph')
xlabel('x')
ylabel('y1 (red) and y2 (blue)')
figure

% histogram (frequency diagram)
% random number with normal distribution
x = randn(1,10000); 
hist(x)
title('randn(1,10000) - normal distribution')
figure

% random number with uniform distribution
x = rand(1,10000);
hist(x)
title('rand(1,10000) - uniform distribution')
figure

% surface and contour plots
% of the function z = (x + 0.5*y - 5) ^ 2
x = 0:0.1:5; 
y = 0:0.2:10; 
[X,Y] = meshgrid(x,y); 
Z = (X + 0.5*Y -5) .^2;
% surface plot
surf(X,Y,Z)
title('Surface plot: z = (x + 0.5*y - 5) ^ 2')
figure
% contour lines (level curves)
title('Contour lines: z = (x + 0.5*y - 5) ^ 2')
[C,h]= contour(X,Y,Z, [0:5:50]);
clabel(C,h,[0:5:50]);

disp('***********************************************************')
disp('Constrained optimization')
disp('***********************************************************')
% general syntax:
% x = fmincon(fun,x0,A,b,Aeq,beq,lb,ub)
% - fun: single-output objective function whose return is to be minimized
% - x0: start value for vector x
% - inequality constraint: Ax ? b
% - equality constraint: Aeq x = beq
% - lb: lower bound for x
% - hb: higher bound for x

% Constrained optimization problem:
% Minimize z = sin(x + 0.5y) subject to constraints:
% x + y ? 5 and x - y ? 2

disp('STEP 1: Create objective function objfun') 
% check text file objfun.m in the current directory
% Note: x --> v(1), y --> v(2)
%
% function z = objfun(v) 
% z = sin(v(1) + 0.5*v(2))
% end

% Test objective function
z_test = objfun([2 6]) 

disp('STEP 2: Formulate boundary conditions')
% inequlity condition:
% -(x +y) ? -5
% x - y ? 2
A = [-1 -1; 1 -1]
b = [-5 2]

% there is no equality condition
Aeq = []; % empty matrix 
beq = [];
% there are no lower or upper boundaries for x or y (v(1) or v(2))
lb = [];
ub = [];
% set a starting point for vector v
v0 = [0 0]

disp('STEP 3: Run optimization function')
v = fmincon(@objfun,v0,A,b,Aeq,beq,lb,ub);

% Test the result
% Value of objective function at this point v
z_opt = objfun(v)
% Inequality condition 1: check if x + y ? 5
v_sum = sum(v)
% Inequality condition 2: check if x - y ? 2
v1_minus_v2 = v(1)-v(2)

% finaquant Financial Analytics - www.finaquant.com
% Tunc Ali Ktkcoglu  2012
